## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.path = "man/figures/"
)


## ----data---------------------------------------------------------------------
df <- data.frame(station = c("1","1","1","1","1","1",
                             "2","2","2","2","2","2"),
                 species = c("Acidostoma neglectum",
                             "Acrocirrus validus",
                             "Acteocina bullata",
                             "Austrohelice crassa",
                             "Capitella nonatoi",
                             "Watersipora subatra",
                             "Zanclea giancarloi",
                             "Zanclea sessilis",
                             "Zonorhynchus sp.",
                             "Acholoe squamosa",
                             "Aglaophenia kirchenpaueri",
                             "Tricellaria sp."),
                 count = c(2, 4, 5, 3, 7, 2, 4, 5, 3, 7, 2, 3))

## ----step1, eval=FALSE, include=TRUE------------------------------------------
# library(ambiR)
# 
# AMBI(df, by = c("station"), quiet=F, interactive = T)
# #>
# #> ── Assigning unrecognised species ──────────────────────────────────────────────
# #>
# #> • 7 species names were not recognised. These will now be displayed, one at a
# #> time.
# #>
# #> • For each species, you can assign it to one of the five AMBI categories (I,
# #> II, III, IV, V). Do this by entering an integer value from 1 to 5.
# #> Alternatively, you can assign a value of 0. This indicates that the species
# #> name is recognised but it is not possible to assign it to one of the five
# #> categories.
# #>
# #> • If Enter is pressed, without providing a value, no change will be made. The
# #> species name in question will be treated as unrecognised.
# #>
# #> • Enter s at the prompt to see a list of similar species names and their
# #> corresponding AMBI categories.
# #>
# #> • Enter x to abort the interactive species selection. Any entries made up to
# #> that point will be discarded. All 7 species will be treated as unrecognised.
# #>
# #> ── 1 Acholoe squamosa ──
# #>
# #> ℹ enter an integer value from 0 to 5 or press Enter to skip. s - see similar
# #>  names. x - abort interactive assignment.

## ----step2, eval=FALSE, include=TRUE------------------------------------------
#   s
# #> • Achelous ordwayi                                 (Group 1)
# #> • Acidostoma hancocki                              (Group 2)
# #> • Acidostoma neglectum                             (Group 0)
# #> • Acidostoma nodiferum                             (Group 1)
# #> • Acidostoma obesum                                (Group 1)
# #> • Acidostoma sarsi                                 (Group 1)
# #> • Acidostoma sp.                                   (Group 1)
# #> • Acila castrensis                                 (Group 2)
# #> • Acila insignis                                   (Group 2)
# #> • Aclis gulsonae                                   (Group 1)
# #> ℹ enter an integer value from 0 to 5 or press Enter to skip. s - see similar
# #>  names. x - abort interactive assignment.

## ----step3, eval=FALSE, include=TRUE------------------------------------------
#   0
# #> ✔  Acholoe squamosa - Not assigned
# #>
# #> ── 2 Aglaophenia kirchenpaueri ──
# #>
# #> ℹ enter an integer value from 0 to 5 or press Enter to skip. s - see similar
# #>  names. x - abort interactive assignment.

## ----step4, eval=FALSE, include=TRUE------------------------------------------
#   s
# #> • Aglaophamus verrilli                             (Group 2)
# #> • Aglaophenia acacia                               (Group 0)
# #> • Aglaophenia pluma                                (Group 0)
# #> • Agnezia septentrionalis                          (Group 2)
# #> • Aidanosagitta crassa                             (Group 1)
# #> • Aiptasia diaphana                                (Group 3)
# #> • Aiptasia mutabilis                               (Group 3)
# #> • Akanthophoreus gracilis                          (Group 1)
# #> • Akera bullata                                    (Group 1)
# #> • Akera sp.                                        (Group 1)
# #> ℹ enter an integer value from 0 to 5 or press Enter to skip. s - see similar
# #>  names. x - abort interactive assignment.

## ----step5, eval=FALSE, include=TRUE------------------------------------------
#   0
# #> ✔ Aglaophenia kirchenpaueri - Not assigned
# #>
# #> ── 3 Tricellaria sp. ──
# #>
# #> ℹ enter an integer value from 0 to 5 or press Enter to skip. s - see similar
# #>  names. x - abort interactive assignment.

## ----matched, eval=FALSE, include=TRUE----------------------------------------
# $matched
# #>  station                   species           species_matched count group source RA
# #>  1        1      Acidostoma neglectum      Acidostoma neglectum     2     0   <NA>  0
# #>  2        1        Acrocirrus validus        Acrocirrus validus     4     4   <NA>  0
# #>  3        1         Acteocina bullata         Acteocina bullata     5     1   <NA>  0
# #>  4        1       Austrohelice crassa       Austrohelice crassa     3     5   <NA>  0
# #>  5        1         Capitella nonatoi         Capitella nonatoi     7     5   <NA>  0
# #>  6        1       Watersipora subatra       Watersipora subatra     2     0      I NA
# #>  7        2        Zanclea giancarloi        Zanclea giancarloi     4     0      I NA
# #>  8        2          Zanclea sessilis          Zanclea sessilis     5     0      I NA
# #>  9        2          Zonorhynchus sp.          Zonorhynchus sp.     3     0      I NA
# #>  10       2          Acholoe squamosa          Acholoe squamosa     7     0      I NA
# #>  11       2 Aglaophenia kirchenpaueri Aglaophenia kirchenpaueri     2     0      I NA
# #>  12       2           Tricellaria sp.           Tricellaria sp.     3     3      I NA

## ----step6, eval=FALSE, include=TRUE------------------------------------------
#   x
# 
# > ! interactive species assignment cancelled

