/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.math.functions;

import java.util.Arrays;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class ObjectiveFunctionPoint {
    private final double value;
    @NonNull
    private final double[] parameters;
    private final double[] gradient;
    private final Matrix hessian;

    @Generated
    public ObjectiveFunctionPoint(double value, @NonNull double[] parameters, double[] gradient, Matrix hessian) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        this.value = value;
        this.parameters = parameters;
        this.gradient = gradient;
        this.hessian = hessian;
    }

    @Generated
    public double getValue() {
        return this.value;
    }

    @NonNull
    @Generated
    public double[] getParameters() {
        return this.parameters;
    }

    @Generated
    public double[] getGradient() {
        return this.gradient;
    }

    @Generated
    public Matrix getHessian() {
        return this.hessian;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectiveFunctionPoint)) {
            return false;
        }
        ObjectiveFunctionPoint other = (ObjectiveFunctionPoint)o;
        if (Double.compare(this.getValue(), other.getValue()) != 0) {
            return false;
        }
        if (!Arrays.equals(this.getParameters(), other.getParameters())) {
            return false;
        }
        if (!Arrays.equals(this.getGradient(), other.getGradient())) {
            return false;
        }
        Matrix this$hessian = this.getHessian();
        Matrix other$hessian = other.getHessian();
        return !(this$hessian == null ? other$hessian != null : !this$hessian.equals(other$hessian));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        result = result * 59 + Arrays.hashCode(this.getParameters());
        result = result * 59 + Arrays.hashCode(this.getGradient());
        Matrix $hessian = this.getHessian();
        result = result * 59 + ($hessian == null ? 43 : $hessian.hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "ObjectiveFunctionPoint(value=" + this.getValue() + ", parameters=" + Arrays.toString(this.getParameters()) + ", gradient=" + Arrays.toString(this.getGradient()) + ", hessian=" + String.valueOf(this.getHessian()) + ")";
    }
}

