/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.com.github.miachm.sods;

import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import standalone_spreadsheet.com.github.miachm.sods.ColumnStyle;
import standalone_spreadsheet.com.github.miachm.sods.OfficeAnnotation;
import standalone_spreadsheet.com.github.miachm.sods.OfficeAnnotationBuilder;
import standalone_spreadsheet.com.github.miachm.sods.OfficeValueType;
import standalone_spreadsheet.com.github.miachm.sods.Pair;
import standalone_spreadsheet.com.github.miachm.sods.Range;
import standalone_spreadsheet.com.github.miachm.sods.RowStyle;
import standalone_spreadsheet.com.github.miachm.sods.Sheet;
import standalone_spreadsheet.com.github.miachm.sods.Style;
import standalone_spreadsheet.com.github.miachm.sods.StylesParser;
import standalone_spreadsheet.com.github.miachm.sods.TableStyle;
import standalone_spreadsheet.com.github.miachm.sods.Vector;
import standalone_spreadsheet.com.github.miachm.sods.XmlReaderInstance;

class SheetParser {
    private static final int BUGGED_COUNT = 10000;
    private final Sheet sheet;
    private final StylesParser stylesParser;
    private final Map<Integer, Style> columnDefaultStyles = new HashMap<Integer, Style>();
    private final Map<Integer, Style> rowDefaultStyles = new HashMap<Integer, Style>();
    private final Set<Pair<Vector, Vector>> groupCells = new HashSet<Pair<Vector, Vector>>();

    public SheetParser(Sheet sheet, StylesParser stylesParser) {
        this.sheet = sheet;
        this.stylesParser = stylesParser;
    }

    public void parseSheet(XmlReaderInstance reader) {
        XmlReaderInstance instance;
        String protectedSheet;
        String tableStyleName = reader.getAttribValue("table:style-name");
        if (tableStyleName != null) {
            this.setTableStyles(tableStyleName);
        }
        if ((protectedSheet = reader.getAttribValue("table:protected")) != null) {
            String algorithm = reader.getAttribValue("table:protection-key-digest-algorithm");
            if (algorithm == null) {
                algorithm = "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            String protectedKey = reader.getAttribValue("table:protection-key");
            this.sheet.setRawPassword(protectedKey, algorithm);
        }
        int rowCount = 0;
        this.groupCells.clear();
        while (reader.hasNext() && (instance = reader.nextElement("table:table-column", "table:table-row")) != null) {
            RowStyle rowStyle;
            String rowStyleName;
            Style style;
            String styleName = instance.getAttribValue("table:default-cell-style-name");
            Style style2 = style = styleName != null ? this.stylesParser.getCellStyle(styleName) : null;
            if (instance.getTag().equals("table:table-column")) {
                this.parseColumnProperties(instance, style);
                continue;
            }
            if (!instance.getTag().equals("table:table-row")) continue;
            if (style != null) {
                this.rowDefaultStyles.put(rowCount, style);
            }
            int numRows = 1;
            String numRowsStr = instance.getAttribValue("table:number-rows-repeated");
            if (numRowsStr != null) {
                try {
                    numRows = Integer.parseInt(numRowsStr);
                    if (numRows > 10000) {
                        continue;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.sheet.appendRows(numRows);
            String visibility = instance.getAttribValue("table:visibility");
            if ("collapse".equals(visibility)) {
                this.sheet.hideRows(this.sheet.getMaxRows() - numRows, numRows);
            }
            if ((rowStyleName = instance.getAttribValue("table:style-name")) != null && (rowStyle = this.stylesParser.getRowStyle(rowStyleName)) != null) {
                this.sheet.setRowHeights(this.sheet.getMaxRows() - numRows, numRows, rowStyle.getHeight());
            }
            this.processCells(instance, numRows);
            rowCount += numRows;
        }
        for (Pair<Vector, Vector> pair : this.groupCells) {
            Vector cord = (Vector)pair.first;
            Vector length = (Vector)pair.second;
            Range range = this.sheet.getRange(cord.getX(), cord.getY(), length.getX(), length.getY());
            range.merge();
        }
    }

    private void setTableStyles(String tableStyleName) {
        TableStyle style = this.stylesParser.getTableStyle(tableStyleName);
        if (style != null && style.isHidden()) {
            this.sheet.hideSheet();
        }
    }

    private void parseColumnProperties(XmlReaderInstance instance, Style style) {
        ColumnStyle columnStyle;
        String columnStyleName;
        boolean areHidden = "collapse".equals(instance.getAttribValue("table:visibility"));
        int numColumns = 1;
        String columnsRepeated = instance.getAttribValue("table:number-columns-repeated");
        if (columnsRepeated != null && (numColumns = Integer.parseInt(columnsRepeated)) > 10000) {
            return;
        }
        int index = this.sheet.getMaxColumns();
        this.sheet.appendColumns(numColumns);
        if (style != null && !style.isDefault()) {
            for (int j = index; j < index + numColumns; ++j) {
                this.sheet.setDefaultColumnCellStyle(j, style);
                this.columnDefaultStyles.put(j, style);
            }
        }
        if (areHidden) {
            this.sheet.hideColumns(index, numColumns);
        }
        if ((columnStyleName = instance.getAttribValue("table:style-name")) != null && (columnStyle = this.stylesParser.getColumnStyle(columnStyleName)) != null) {
            this.sheet.setColumnWidths(this.sheet.getMaxColumns() - numColumns, numColumns, columnStyle.getWidth());
        }
    }

    private void processCells(XmlReaderInstance reader, int numberRowsRepeated) {
        int column = 0;
        while (reader.hasNext()) {
            String columnsSpanned;
            int numberColumnsRepeated = 1;
            Object lastCellValue = null;
            Object lastStyle = null;
            XmlReaderInstance instance = reader.nextElement("table:table-cell", "table:covered-table-cell");
            if (instance == null) break;
            if (instance.getTag().equals("table:covered-table-cell")) {
                String numColumnsRepeated = instance.getAttribValue("table:number-columns-repeated");
                column += numColumnsRepeated == null ? 1 : Integer.parseInt(numColumnsRepeated);
                continue;
            }
            int rows = 1;
            int columns = 1;
            String rowsSpanned = instance.getAttribValue("table:number-rows-spanned");
            if (rowsSpanned != null) {
                rows = Integer.parseInt(rowsSpanned);
            }
            if ((columnsSpanned = instance.getAttribValue("table:number-columns-spanned")) != null) {
                columns = Integer.parseInt(columnsSpanned);
            }
            if (numberRowsRepeated == 1 && (rows != 1 || columns != 1)) {
                Pair pair = new Pair();
                pair.first = new Vector(this.sheet.getMaxRows() - 1, column);
                pair.second = new Vector(rows, columns);
                this.groupCells.add(pair);
            }
            int positionX = this.sheet.getMaxRows() - numberRowsRepeated;
            int positionY = column;
            OfficeValueType valueType = OfficeValueType.ofReader(instance);
            Object value = valueType.read(instance);
            String raw = instance.getAttribValue("table:number-columns-repeated");
            if (raw != null && (numberColumnsRepeated = Integer.parseInt(raw)) > 10000) continue;
            if (positionY + numberColumnsRepeated > this.sheet.getMaxColumns()) {
                this.sheet.appendColumns(positionY + numberColumnsRepeated - this.sheet.getMaxColumns());
            }
            Range range = this.sheet.getRange(positionX, positionY, numberRowsRepeated, numberColumnsRepeated);
            String formula = instance.getAttribValue("table:formula");
            if (formula != null) {
                range.setFormula(formula);
            }
            range.setValue(value);
            Style style = this.stylesParser.getCellStyle(instance.getAttribValue("table:style-name"));
            if (style == null) {
                style = this.columnDefaultStyles.get(column);
            }
            if (style == null) {
                style = this.rowDefaultStyles.get(this.sheet.getMaxRows() - 1);
            }
            if (style != null && !style.isDefault()) {
                range.setStyle(style);
            }
            this.readCellText(instance, range);
            column += numberColumnsRepeated;
        }
    }

    private void readCellText(XmlReaderInstance cellReader, Range range) {
        XmlReaderInstance textElement;
        StringBuffer s = new StringBuffer();
        boolean firstTextElement = true;
        while ((textElement = cellReader.nextElement("text:p", "text:h", "office:annotation")) != null) {
            XmlReaderInstance spanElement;
            if (textElement.getTag().equals("office:annotation")) {
                range.setAnnotation(this.getOfficeAnnotation(textElement));
                continue;
            }
            if (firstTextElement) {
                firstTextElement = false;
            } else {
                s.append("\n");
            }
            while ((spanElement = textElement.nextElement("text:s", "characters")) != null) {
                String spanContent;
                if (spanElement.getTag().equals("text:s")) {
                    int num = 1;
                    String attrib = spanElement.getAttribValue("text:c");
                    if (attrib != null && !attrib.isEmpty()) {
                        try {
                            num = Integer.parseInt(attrib);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Invalid number of characters: " + attrib);
                        }
                    }
                    while (num-- > 0) {
                        s.append(" ");
                    }
                }
                if ((spanContent = spanElement.getContent()) == null) continue;
                s.append(spanContent);
            }
        }
        Object value = range.getValue();
        if (s.length() > 0 && (value == null || value instanceof String)) {
            range.setValue(s.toString());
        }
    }

    private OfficeAnnotation getOfficeAnnotation(XmlReaderInstance reader) {
        XmlReaderInstance instance;
        OfficeAnnotationBuilder annotation = new OfficeAnnotationBuilder();
        StringBuilder msg = new StringBuilder();
        while (reader.hasNext() && (instance = reader.nextElement("dc:date", "text:p")) != null) {
            if (instance.getTag().equals("dc:date")) {
                if ((instance = instance.nextElement("characters")) == null) continue;
                String content = instance.getContent();
                try {
                    if (content == null) continue;
                    annotation.setLastModified(LocalDateTime.parse(content));
                }
                catch (DateTimeParseException e) {
                    System.err.println("DATE INVALID IN OFFICE ANNOTATION");
                }
                continue;
            }
            if (!instance.getTag().equals("text:p")) continue;
            instance = instance.nextElement("characters");
            if (msg.length() > 0) {
                msg.append("\n");
            }
            if (instance == null) continue;
            msg.append(instance.getContent());
        }
        annotation.setMsg(msg.toString());
        return annotation.build();
    }
}

