## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(clinTrialData)

# Studies on your machine (bundled + previously downloaded)
list_data_sources()

## -----------------------------------------------------------------------------
# Connect to CDISC Pilot data
db <- connect_clinical_data("cdisc_pilot")

# List available datasets in the ADaM domain
db$adam$list_content_cnt()

# Read the subject-level dataset
adsl <- db$adam$read_cnt("adsl")
head(adsl[, c("USUBJID", "TRT01A", "AGE", "SEX", "RACE")])

## ----eval=FALSE---------------------------------------------------------------
# # What's available to download?
# list_available_studies()
# 
# # Download a study once — cached locally from then on
# download_study("cdisc_pilot_extended")
# 
# # Where is the cache?
# cache_dir()

## -----------------------------------------------------------------------------
# Dimensions
dim(adsl)

# Quick structure overview
str(adsl, list.len = 10)

## -----------------------------------------------------------------------------
# Read adverse events data
adae <- db$adam$read_cnt("adae")
head(adae[, c("USUBJID", "AEDECOD", "AESEV", "AESER")])

## -----------------------------------------------------------------------------
# Read demographics
dm <- db$sdtm$read_cnt("dm")
head(dm[, c("USUBJID", "ARM", "AGE", "SEX", "RACE")])

## -----------------------------------------------------------------------------
library(dplyr)

# Basic demographic summary by treatment
adsl |>
  group_by(TRT01A) |>
  summarise(
    n = n(),
    mean_age = mean(AGE, na.rm = TRUE),
    female_pct = mean(SEX == "F", na.rm = TRUE) * 100,
    .groups = "drop"
  )

