/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.api.regarima;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.api.util.Validatable;
import jdplus.x13.base.api.regarima.SingleOutlierSpec;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class OutlierSpec
implements Validatable<OutlierSpec> {
    public static final OutlierSpec DEFAULT_DISABLED = (OutlierSpec)OutlierSpec.builder().build();
    public static final OutlierSpec DEFAULT_ENABLED = (OutlierSpec)OutlierSpec.builder().type(new SingleOutlierSpec("AO", 0.0)).type(new SingleOutlierSpec("LS", 0.0)).build();
    public static final double DEF_TCRATE = 0.7;
    public static final int DEF_NMAX = 30;
    private final List<SingleOutlierSpec> types;
    private final int lsRun;
    private final Method method;
    private final double monthlyTCRate;
    private final double defaultCriticalValue;
    @NonNull
    private final TimeSelector span;
    private final int maxIter;

    public static Builder builder() {
        return new Builder().lsRun(0).method(Method.AddOne).monthlyTCRate(0.7).defaultCriticalValue(0.0).span(TimeSelector.all()).maxIter(30);
    }

    public static Builder of(boolean ao, boolean ls, boolean tc, boolean so) {
        Builder builder = OutlierSpec.builder();
        if (ao) {
            builder.type(new SingleOutlierSpec("AO", 0.0));
        }
        if (ls) {
            builder.type(new SingleOutlierSpec("LS", 0.0));
        }
        if (tc) {
            builder.type(new SingleOutlierSpec("TC", 0.0));
        }
        if (so) {
            builder.type(new SingleOutlierSpec("SO", 0.0));
        }
        return builder;
    }

    public OutlierSpec validate() throws IllegalArgumentException {
        return this;
    }

    public boolean isUsed() {
        return !this.types.isEmpty();
    }

    public int getTypesCount() {
        return this.types.size();
    }

    public SingleOutlierSpec search(String type) {
        for (SingleOutlierSpec s : this.types) {
            if (!s.getType().equals(type)) continue;
            return s;
        }
        return null;
    }

    public boolean isDefault() {
        return this.equals(DEFAULT_DISABLED);
    }

    @Generated
    OutlierSpec(List<SingleOutlierSpec> types, int lsRun, Method method, double monthlyTCRate, double defaultCriticalValue, @NonNull TimeSelector span, int maxIter) {
        if (span == null) {
            throw new NullPointerException("span is marked non-null but is null");
        }
        this.types = types;
        this.lsRun = lsRun;
        this.method = method;
        this.monthlyTCRate = monthlyTCRate;
        this.defaultCriticalValue = defaultCriticalValue;
        this.span = span;
        this.maxIter = maxIter;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        Builder builder = new Builder().lsRun(this.lsRun).method(this.method).monthlyTCRate(this.monthlyTCRate).defaultCriticalValue(this.defaultCriticalValue).span(this.span).maxIter(this.maxIter);
        if (this.types != null) {
            builder.types(this.types);
        }
        return builder;
    }

    @Generated
    public List<SingleOutlierSpec> getTypes() {
        return this.types;
    }

    @Generated
    public int getLsRun() {
        return this.lsRun;
    }

    @Generated
    public Method getMethod() {
        return this.method;
    }

    @Generated
    public double getMonthlyTCRate() {
        return this.monthlyTCRate;
    }

    @Generated
    public double getDefaultCriticalValue() {
        return this.defaultCriticalValue;
    }

    @NonNull
    @Generated
    public TimeSelector getSpan() {
        return this.span;
    }

    @Generated
    public int getMaxIter() {
        return this.maxIter;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutlierSpec)) {
            return false;
        }
        OutlierSpec other = (OutlierSpec)o;
        if (this.getLsRun() != other.getLsRun()) {
            return false;
        }
        if (Double.compare(this.getMonthlyTCRate(), other.getMonthlyTCRate()) != 0) {
            return false;
        }
        if (Double.compare(this.getDefaultCriticalValue(), other.getDefaultCriticalValue()) != 0) {
            return false;
        }
        if (this.getMaxIter() != other.getMaxIter()) {
            return false;
        }
        List<SingleOutlierSpec> this$types = this.getTypes();
        List<SingleOutlierSpec> other$types = other.getTypes();
        if (this$types == null ? other$types != null : !((Object)this$types).equals(other$types)) {
            return false;
        }
        Method this$method = this.getMethod();
        Method other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        TimeSelector this$span = this.getSpan();
        TimeSelector other$span = other.getSpan();
        return !(this$span == null ? other$span != null : !this$span.equals(other$span));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLsRun();
        long $monthlyTCRate = Double.doubleToLongBits(this.getMonthlyTCRate());
        result = result * 59 + (int)($monthlyTCRate >>> 32 ^ $monthlyTCRate);
        long $defaultCriticalValue = Double.doubleToLongBits(this.getDefaultCriticalValue());
        result = result * 59 + (int)($defaultCriticalValue >>> 32 ^ $defaultCriticalValue);
        result = result * 59 + this.getMaxIter();
        List<SingleOutlierSpec> $types = this.getTypes();
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        TimeSelector $span = this.getSpan();
        result = result * 59 + ($span == null ? 43 : $span.hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "OutlierSpec(types=" + String.valueOf(this.getTypes()) + ", lsRun=" + this.getLsRun() + ", method=" + String.valueOf((Object)this.getMethod()) + ", monthlyTCRate=" + this.getMonthlyTCRate() + ", defaultCriticalValue=" + this.getDefaultCriticalValue() + ", span=" + String.valueOf(this.getSpan()) + ", maxIter=" + this.getMaxIter() + ")";
    }

    public static class Builder
    implements Validatable.Builder<OutlierSpec> {
        @Generated
        private ArrayList<SingleOutlierSpec> types;
        @Generated
        private int lsRun;
        @Generated
        private Method method;
        @Generated
        private double monthlyTCRate;
        @Generated
        private double defaultCriticalValue;
        @Generated
        private TimeSelector span;
        @Generated
        private int maxIter;

        public Builder defaultCriticalValue(double defaultCriticalValue) {
            if (this.types == null) {
                this.types = new ArrayList();
            }
            for (int i = 0; i < this.types.size(); ++i) {
                this.types.set(i, new SingleOutlierSpec(this.types.get(i).getType(), defaultCriticalValue));
            }
            this.defaultCriticalValue = defaultCriticalValue;
            return this;
        }

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder type(SingleOutlierSpec type) {
            if (this.types == null) {
                this.types = new ArrayList();
            }
            this.types.add(type);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder types(@org.jspecify.annotations.NonNull Collection<? extends SingleOutlierSpec> types) {
            if (types == null) {
                throw new NullPointerException("types cannot be null");
            }
            if (this.types == null) {
                this.types = new ArrayList();
            }
            this.types.addAll(types);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearTypes() {
            if (this.types != null) {
                this.types.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder lsRun(int lsRun) {
            this.lsRun = lsRun;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder method(Method method) {
            this.method = method;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder monthlyTCRate(double monthlyTCRate) {
            this.monthlyTCRate = monthlyTCRate;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder span(@NonNull TimeSelector span) {
            if (span == null) {
                throw new NullPointerException("span is marked non-null but is null");
            }
            this.span = span;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder maxIter(int maxIter) {
            this.maxIter = maxIter;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull OutlierSpec buildWithoutValidation() {
            return new OutlierSpec(switch (this.types == null ? 0 : this.types.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.types.get(0));
                default -> Collections.unmodifiableList(new ArrayList<SingleOutlierSpec>(this.types));
            }, this.lsRun, this.method, this.monthlyTCRate, this.defaultCriticalValue, this.span, this.maxIter);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "OutlierSpec.Builder(types=" + String.valueOf(this.types) + ", lsRun=" + this.lsRun + ", method=" + String.valueOf((Object)this.method) + ", monthlyTCRate=" + this.monthlyTCRate + ", defaultCriticalValue=" + this.defaultCriticalValue + ", span=" + String.valueOf(this.span) + ", maxIter=" + this.maxIter + ")";
        }
    }

    public static enum Method {
        AddOne,
        AddAll;

    }
}

