/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.diagnostics;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdplus.toolkit.base.api.processing.Diagnostics;
import jdplus.toolkit.base.api.processing.DiagnosticsFactory;
import jdplus.toolkit.base.core.regarima.diagnostics.OutliersDiagnostics;
import jdplus.toolkit.base.core.regarima.diagnostics.OutliersDiagnosticsConfiguration;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;
import lombok.NonNull;

public class OutliersDiagnosticsFactory<R>
implements DiagnosticsFactory<OutliersDiagnosticsConfiguration, R> {
    public static final String NUMBER = "number of outliers";
    public static final String NAME = "Outliers";
    public static final List<String> ALL = Collections.singletonList("number of outliers");
    private final OutliersDiagnosticsConfiguration config;
    protected final Function<R, RegSarimaModel> extractor;

    public OutliersDiagnosticsFactory(@NonNull OutliersDiagnosticsConfiguration config, @NonNull Function<R, RegSarimaModel> extractor) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        if (extractor == null) {
            throw new NullPointerException("extractor is marked non-null but is null");
        }
        this.config = config;
        this.extractor = extractor;
    }

    public OutliersDiagnosticsConfiguration getConfiguration() {
        return this.config;
    }

    public OutliersDiagnosticsFactory<R> with(OutliersDiagnosticsConfiguration config) {
        return new OutliersDiagnosticsFactory<R>(config, this.extractor);
    }

    public String getName() {
        return NAME;
    }

    public List<String> getTestDictionary() {
        return ALL.stream().map(s -> s + ":2").collect(Collectors.toList());
    }

    public Diagnostics of(R rslts) {
        return OutliersDiagnostics.create(this.extractor.apply(rslts), this.config);
    }
}

