/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearfilters;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.FilterUtility;
import jdplus.toolkit.base.core.math.linearfilters.IRationalFilter;
import jdplus.toolkit.base.core.math.linearfilters.RationalForeFilter;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.RationalFunction;

public final class RationalBackFilter
implements IRationalFilter {
    public static final RationalBackFilter ZERO = new RationalBackFilter();
    private final RationalFunction rationalFunction;
    private final int bshift;

    public RationalBackFilter() {
        this.rationalFunction = RationalFunction.zero();
        this.bshift = 0;
    }

    public RationalBackFilter(BackFilter num, BackFilter denom, int bshift) {
        this.rationalFunction = RationalFunction.of(num.asPolynomial(), denom.asPolynomial());
        this.bshift = bshift;
    }

    public RationalBackFilter(RationalFunction rfe, int bshift) {
        this.rationalFunction = rfe;
        this.bshift = bshift;
    }

    public RationalBackFilter drop(int nterms) {
        RationalFunction rfe = this.rationalFunction.drop(nterms);
        return new RationalBackFilter(rfe, this.bshift + nterms);
    }

    @Override
    public Complex frequencyResponse(double freq) {
        Polynomial pn = this.rationalFunction.getNumerator();
        Polynomial pd = this.rationalFunction.getDenominator();
        Complex n = FilterUtility.frequencyResponse(i -> pn.get(i - this.bshift), this.bshift, this.bshift + pn.degree(), -freq);
        Complex d = FilterUtility.frequencyResponse(i -> pd.get(i), 0, this.rationalFunction.getDenominator().degree(), -freq);
        return n.div(d);
    }

    @Override
    public BackFilter getDenominator() {
        Polynomial p = this.rationalFunction.getDenominator();
        return new BackFilter(p);
    }

    public int getLBound() {
        if (this.rationalFunction.isFinite()) {
            return -this.rationalFunction.getNumerator().degree();
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public BackFilter getNumerator() {
        Polynomial p = this.rationalFunction.getNumerator();
        return new BackFilter(p);
    }

    public RationalFunction getRationalFunction() {
        return this.rationalFunction;
    }

    public int getUBound() {
        return -this.bshift;
    }

    public double weight(int pos) {
        return this.rationalFunction.get(-this.bshift - pos);
    }

    public IntToDoubleFunction asFunction() {
        return pos -> this.weight(pos);
    }

    public double[] getWeights(int n) {
        return this.rationalFunction.coefficients(n);
    }

    @Override
    public boolean hasLowerBound() {
        return this.rationalFunction.isFinite();
    }

    @Override
    public boolean hasUpperBound() {
        return true;
    }

    public RationalForeFilter mirror() {
        return new RationalForeFilter(this.rationalFunction, this.bshift);
    }

    public void prepare(int n) {
        this.rationalFunction.prepare(n);
    }

    public RationalBackFilter times(RationalBackFilter r) {
        Polynomial ln = this.rationalFunction.getNumerator();
        Polynomial rn = r.rationalFunction.getNumerator();
        Polynomial ld = this.rationalFunction.getDenominator();
        Polynomial.SimplifyingTool psmp = new Polynomial.SimplifyingTool();
        Polynomial rd = r.rationalFunction.getDenominator();
        if (psmp.simplify(ln, rd)) {
            ln = (Polynomial)psmp.getLeft();
            rd = (Polynomial)psmp.getRight();
        }
        if (psmp.simplify(rn, ld)) {
            rn = (Polynomial)psmp.getLeft();
            ld = (Polynomial)psmp.getRight();
        }
        Polynomial n = ln.times(rn);
        Polynomial d = ld.times(rd);
        RationalFunction rfe = RationalFunction.of(n, d);
        return new RationalBackFilter(rfe, this.bshift + r.bshift);
    }

    @Override
    public RationalBackFilter getRationalBackFilter() {
        return this;
    }

    @Override
    public RationalForeFilter getRationalForeFilter() {
        return RationalForeFilter.ZERO;
    }
}

