/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.math.functions.gsl.derivation;

import internal.toolkit.base.core.math.functions.gsl.derivation.DerivationResult;
import internal.toolkit.base.core.math.functions.gsl.derivation.MDerivationResult;
import java.util.function.DoubleFunction;
import java.util.function.DoubleUnaryOperator;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import lombok.Generated;

public final class GslDerivation {
    private static DerivationResult central_derivation(DoubleUnaryOperator fn, double x, double h) {
        double fm1 = fn.applyAsDouble(x - h);
        double fp1 = fn.applyAsDouble(x + h);
        double fmh = fn.applyAsDouble(x - h / 2.0);
        double fph = fn.applyAsDouble(x + h / 2.0);
        double r3 = 0.5 * (fp1 - fm1);
        double r5 = 1.3333333333333333 * (fph - fmh) - 0.3333333333333333 * r3;
        double e3 = (Math.abs(fp1) + Math.abs(fm1)) * 2.220446049250313E-16;
        double e5 = 2.0 * (Math.abs(fph) + Math.abs(fmh)) * 2.220446049250313E-16 + e3;
        double dy = Math.max(Math.abs(r3 / h), Math.abs(r5 / h)) * (Math.abs(x) / h) * 2.220446049250313E-16;
        return new DerivationResult(r5 / h, Math.abs((r5 - r3) / h), Math.abs(e5 / h) + dy);
    }

    public static double centralDerivation(DoubleUnaryOperator fn, double x, double h) {
        DerivationResult r0 = GslDerivation.central_derivation(fn, x, h);
        double r_0 = r0.getDf();
        double trunc = r0.getTruncationError();
        double round = r0.getRoundingError();
        double error = round + trunc;
        if (round < trunc && round > 0.0 && trunc > 0.0) {
            double h_opt = h * Math.pow(round / (2.0 * trunc), 0.3333333333333333);
            DerivationResult opt = GslDerivation.central_derivation(fn, x, h_opt);
            double trunc_opt = opt.getTruncationError();
            double round_opt = opt.getRoundingError();
            double error_opt = round_opt + trunc_opt;
            double r_opt = opt.getDf();
            if (error_opt < error && Math.abs(r_opt - r_0) < 4.0 * error) {
                return r_opt;
            }
        }
        return r_0;
    }

    static DerivationResult forward_derivation(DoubleUnaryOperator fn, double x, double h) {
        double f1 = fn.applyAsDouble(x + h / 4.0);
        double f2 = fn.applyAsDouble(x + h / 2.0);
        double f3 = fn.applyAsDouble(x + 0.75 * h);
        double f4 = fn.applyAsDouble(x + h);
        double r2 = 2.0 * (f4 - f2);
        double r4 = 7.333333333333333 * (f4 - f3) - 20.666666666666668 * (f3 - f2) + 17.333333333333332 * (f2 - f1);
        double e4 = 41.34 * (Math.abs(f4) + Math.abs(f3) + Math.abs(f2) + Math.abs(f1)) * 2.220446049250313E-16;
        double dy = Math.max(Math.abs(r2 / h), Math.abs(r4 / h)) * Math.abs(x / h) * 2.220446049250313E-16;
        return new DerivationResult(r4 / h, Math.abs((r4 - r2) / h), Math.abs(e4 / h) + dy);
    }

    public static double forwardDerivation(DoubleUnaryOperator fn, double x, double h) {
        DerivationResult r0 = GslDerivation.forward_derivation(fn, x, h);
        double r_0 = r0.getDf();
        double trunc = r0.getTruncationError();
        double round = r0.getRoundingError();
        double error = round + trunc;
        if (round < trunc && round > 0.0 && trunc > 0.0) {
            double h_opt = h * Math.pow(round / trunc, 0.5);
            DerivationResult opt = GslDerivation.forward_derivation(fn, x, h_opt);
            double trunc_opt = opt.getTruncationError();
            double round_opt = opt.getRoundingError();
            double error_opt = round_opt + trunc_opt;
            double r_opt = opt.getDf();
            if (error_opt < error && Math.abs(r_opt - r_0) < 4.0 * error) {
                return r_opt;
            }
        }
        return r_0;
    }

    public static double backwardDerivation(DoubleUnaryOperator fn, double x, double h) {
        return GslDerivation.forwardDerivation(fn, x, -h);
    }

    private static MDerivationResult central_derivation(DoubleFunction<DoubleSeq> fn, double x, double h) {
        DoubleSeq fml = fn.apply(x - h);
        DoubleSeq fpl = fn.apply(x + h);
        DoubleSeq fmh = fn.apply(x - h / 2.0);
        DoubleSeq fph = fn.apply(x + h / 2.0);
        int n = fpl.length();
        double[] df = new double[n];
        double terr = 0.0;
        double rerr = 0.0;
        DoubleSeqCursor plcur = fpl.cursor();
        DoubleSeqCursor mlcur = fml.cursor();
        DoubleSeqCursor phcur = fph.cursor();
        DoubleSeqCursor mhcur = fmh.cursor();
        for (int i = 0; i < n; ++i) {
            double pl = plcur.getAndNext();
            double ml = mlcur.getAndNext();
            double ph = phcur.getAndNext();
            double mh = mhcur.getAndNext();
            double r3 = 0.5 * (pl - ml);
            double r5 = 1.3333333333333333 * (ph - mh) - 0.3333333333333333 * r3;
            double e3 = (Math.abs(pl) + Math.abs(ml)) * 2.220446049250313E-16;
            double e5 = 2.0 * (Math.abs(ph) + Math.abs(mh)) * 2.220446049250313E-16 + e3;
            double dy = Math.max(Math.abs(r3 / h), Math.abs(r5 / h)) * (Math.abs(x) / h) * 2.220446049250313E-16;
            df[i] = r5 / h;
            double te = Math.abs((r5 - r3) / h);
            double re = Math.abs(e5 / h) + dy;
            if (te > terr) {
                terr = te;
            }
            if (!(re > rerr)) continue;
            rerr = re;
        }
        return new MDerivationResult(df, terr, rerr);
    }

    public static DoubleSeq centralDerivation(DoubleFunction<DoubleSeq> fn, double x, double h) {
        MDerivationResult r0 = GslDerivation.central_derivation(fn, x, h);
        double[] r_0 = r0.getDf();
        double trunc = r0.getTruncationError();
        double round = r0.getRoundingError();
        double error = round + trunc;
        if (round < trunc && round > 0.0 && trunc > 0.0) {
            double h_opt = h * Math.pow(round / (2.0 * trunc), 0.3333333333333333);
            MDerivationResult opt = GslDerivation.central_derivation(fn, x, h_opt);
            double trunc_opt = opt.getTruncationError();
            double round_opt = opt.getRoundingError();
            double error_opt = round_opt + trunc_opt;
            double[] r_opt = opt.getDf();
            double dmax = 0.0;
            for (int i = 0; i < r_0.length; ++i) {
                double d = Math.abs(r_opt[i] - r_0[i]);
                if (!(d > dmax)) continue;
                dmax = d;
            }
            if (error_opt < error && dmax < 4.0 * error) {
                return DoubleSeq.of((double[])r_opt);
            }
        }
        return DoubleSeq.of((double[])r_0);
    }

    static MDerivationResult forward_derivation(DoubleFunction<DoubleSeq> fn, double x, double h) {
        DoubleSeq f1 = fn.apply(x + h / 4.0);
        DoubleSeq f2 = fn.apply(x + h / 2.0);
        DoubleSeq f3 = fn.apply(x + 0.75 * h);
        DoubleSeq f4 = fn.apply(x + h);
        DoubleSeqCursor c1 = f1.cursor();
        DoubleSeqCursor c2 = f2.cursor();
        DoubleSeqCursor c3 = f3.cursor();
        DoubleSeqCursor c4 = f4.cursor();
        int n = f1.length();
        double[] df = new double[n];
        double terr = 0.0;
        double rerr = 0.0;
        for (int i = 0; i < n; ++i) {
            double p1 = c1.getAndNext();
            double p2 = c2.getAndNext();
            double p3 = c3.getAndNext();
            double p4 = c4.getAndNext();
            double r2 = 2.0 * (p4 - p2);
            double r4 = 7.333333333333333 * (p4 - p3) - 20.666666666666668 * (p3 - p2) + 17.333333333333332 * (p2 - p1);
            double e4 = 41.34 * (Math.abs(p4) + Math.abs(p3) + Math.abs(p2) + Math.abs(p1)) * 2.220446049250313E-16;
            double dy = Math.max(Math.abs(r2 / h), Math.abs(r4 / h)) * Math.abs(x / h) * 2.220446049250313E-16;
            double te = Math.abs((r4 - r2) / h);
            double re = Math.abs(e4 / h) + dy;
            df[i] = r4 / h;
            if (te > terr) {
                terr = te;
            }
            if (!(re > rerr)) continue;
            rerr = re;
        }
        return new MDerivationResult(df, terr, rerr);
    }

    public static DoubleSeq forwardDerivation(DoubleFunction<DoubleSeq> fn, double x, double h) {
        MDerivationResult r0 = GslDerivation.forward_derivation(fn, x, h);
        double[] r_0 = r0.getDf();
        double trunc = r0.getTruncationError();
        double round = r0.getRoundingError();
        double error = round + trunc;
        if (round < trunc && round > 0.0 && trunc > 0.0) {
            double h_opt = h * Math.pow(round / trunc, 0.5);
            MDerivationResult opt = GslDerivation.central_derivation(fn, x, h_opt);
            double trunc_opt = opt.getTruncationError();
            double round_opt = opt.getRoundingError();
            double error_opt = round_opt + trunc_opt;
            double[] r_opt = opt.getDf();
            double dmax = 0.0;
            for (int i = 0; i < r_0.length; ++i) {
                double d = Math.abs(r_opt[i] - r_0[i]);
                if (!(d > dmax)) continue;
                dmax = d;
            }
            if (error_opt < error && dmax < 4.0 * error) {
                return DoubleSeq.of((double[])r_opt);
            }
        }
        return DoubleSeq.of((double[])r_0);
    }

    public static DoubleSeq backwardDerivation(DoubleFunction<DoubleSeq> fn, double x, double h) {
        return GslDerivation.forwardDerivation(fn, x, -h);
    }

    @Generated
    private GslDerivation() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

