/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp.cube;

import java.util.Locale;
import java.util.stream.Collector;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.api.timeseries.util.ObsGathering;
import jdplus.toolkit.base.tsp.cube.CubeId;
import lombok.Generated;
import lombok.NonNull;

public final class TableAsCubeUtil {
    @NonNull
    public static String getDisplayName(@NonNull String db, @NonNull String table, @NonNull String value, @NonNull ObsGathering obsGathering) {
        if (db == null) {
            throw new NullPointerException("db is marked non-null but is null");
        }
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (obsGathering == null) {
            throw new NullPointerException("obsGathering is marked non-null but is null");
        }
        return String.format(Locale.ROOT, "%s ~ %s \u00bb %s %s", db, table, value, TableAsCubeUtil.toString(obsGathering));
    }

    @NonNull
    public static String getDisplayName(@NonNull CubeId id, @NonNull Collector<? super String, ?, String> joiner) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (joiner == null) {
            throw new NullPointerException("joiner is marked non-null but is null");
        }
        return id.isVoid() ? "All" : (id.isRoot() ? "" : id.getDimensionValueStream().collect(joiner));
    }

    @NonNull
    public static String getDisplayNodeName(@NonNull CubeId id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return id.isVoid() ? "All" : (id.isRoot() ? "" : id.getDimensionValue(id.getLevel() - 1));
    }

    private static String toString(ObsGathering gathering) {
        return TsUnit.UNDEFINED.equals((Object)gathering.getUnit()) ? "" : "(" + String.valueOf(gathering.getUnit()) + "/" + String.valueOf(gathering.getAggregationType()) + ")";
    }

    @Generated
    private TableAsCubeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

