/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.org.dhatim.fastexcel;

import java.io.IOException;
import java.util.Objects;
import standalone_spreadsheet.org.dhatim.fastexcel.Writer;

class Fill {
    protected static final Fill NONE = new Fill("none", null, true);
    protected static final Fill GRAY125 = new Fill("gray125", null, true);
    private final String patternType;
    private final String colorRgb;
    private final boolean fg;

    Fill(String patternType, String colorRgb, boolean fg) {
        this.patternType = patternType;
        this.colorRgb = colorRgb;
        this.fg = fg;
    }

    static Fill fromColor(String fgColorRgb) {
        return Fill.fromColor(fgColorRgb, true);
    }

    static Fill fromColor(String colorRgb, boolean fg) {
        return new Fill("solid", colorRgb, fg);
    }

    public int hashCode() {
        return Objects.hash(this.patternType, this.colorRgb, this.fg);
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj != null && obj.getClass() == this.getClass()) {
            Fill other = (Fill)obj;
            result = Objects.equals(this.patternType, other.patternType) && Objects.equals(this.colorRgb, other.colorRgb) && Objects.equals(this.fg, other.fg);
        } else {
            result = false;
        }
        return result;
    }

    void write(Writer w) throws IOException {
        w.append("<fill><patternFill patternType=\"").append(this.patternType).append('\"');
        if (this.colorRgb == null) {
            w.append("/>");
        } else {
            w.append("><").append(this.fg ? "fg" : "bg").append("Color rgb=\"").append(this.colorRgb).append("\"/></patternFill>");
        }
        w.append("</fill>");
    }
}

