/*
 * Decompiled with CFR 0.152.
 */
package ec.util.spreadsheet.helpers;

import ec.util.spreadsheet.Book;
import ec.util.spreadsheet.Sheet;
import ec.util.spreadsheet.helpers.ArraySheet;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.ObjIntConsumer;
import lombok.NonNull;

public final class ArrayBook
extends Book
implements Serializable {
    private final ArraySheet[] sheets;

    ArrayBook(@NonNull ArraySheet[] sheets) {
        if (sheets == null) {
            throw new NullPointerException("sheets is marked non-null but is null");
        }
        this.sheets = sheets;
    }

    @Override
    public int getSheetCount2() {
        return this.sheets.length;
    }

    @Override
    public int getSheetCount() {
        return this.sheets.length;
    }

    @Override
    @NonNull
    public ArraySheet getSheet(int sheetIndex) {
        return this.sheets[sheetIndex];
    }

    @Override
    @NonNull
    public String getSheetName(int index) {
        return this.sheets[index].getName();
    }

    @Override
    public void forEach(@NonNull ObjIntConsumer<? super Sheet> action) {
        Objects.requireNonNull(action);
        for (int index = 0; index < this.getSheetCount2(); ++index) {
            action.accept(this.getSheet(index), index);
        }
    }

    @Override
    public void close() {
    }

    @NonNull
    public ArrayBook copy() {
        ArraySheet[] result = new ArraySheet[this.getSheetCount2()];
        for (int s = 0; s < result.length; ++s) {
            result[s] = this.getSheet(s).copy();
        }
        return new ArrayBook(result);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ArrayBook && this.equals((ArrayBook)obj);
    }

    private boolean equals(ArrayBook that) {
        return Arrays.equals(this.sheets, that.sheets);
    }

    public int hashCode() {
        return Arrays.hashCode(this.sheets);
    }

    public String toString() {
        return "ArrayBook[" + this.sheets.length + "]";
    }

    @NonNull
    public static ArrayBook copyOf(@NonNull Book book) throws IOException {
        if (book == null) {
            throw new NullPointerException("book is marked non-null but is null");
        }
        if (book instanceof ArrayBook) {
            return ((ArrayBook)book).copy();
        }
        ArraySheet[] sheets = new ArraySheet[book.getSheetCount2()];
        for (int s = 0; s < sheets.length; ++s) {
            sheets[s] = ArraySheet.copyOf(book.getSheet(s));
        }
        return new ArrayBook(sheets);
    }

    @NonNull
    public static Builder builder() {
        return new ListBuilder();
    }

    private static final class ListBuilder
    extends Builder {
        private final List<ArraySheet> sheets = new ArrayList<ArraySheet>();

        private ListBuilder() {
        }

        @Override
        public Builder clear() {
            this.sheets.clear();
            return this;
        }

        @Override
        public Builder book(Book book) throws IOException {
            for (int i = 0; i < book.getSheetCount2(); ++i) {
                this.sheet(book.getSheet(i));
            }
            return this;
        }

        @Override
        public Builder sheet(Sheet sheet) {
            this.sheets.add(ArraySheet.copyOf(sheet));
            return this;
        }

        @Override
        public ArrayBook build() {
            return new ArrayBook(this.sheets.toArray(new ArraySheet[this.sheets.size()]));
        }
    }

    public static abstract class Builder {
        @NonNull
        public abstract Builder clear();

        @NonNull
        public abstract Builder book(@NonNull Book var1) throws IOException;

        @NonNull
        public abstract Builder sheet(@NonNull Sheet var1);

        @NonNull
        public abstract ArrayBook build();
    }
}

